//  chaser.c -- light chaser implemented on PORTB LEDs
//  implemented and tested on Atmel STK500 with AT90S8515 in rightmost socket
// 
//  Copyleft (!C) 2003 S. Mann
//  (http://www.gnu.org/copyleft/gpl.html);
//  based on Stephen Lacy's "mirror.c"

//#include <io-avr.h> (doesn't compile when this is there)
#include <avr/io.h>
//for the above, you need to apt-get install 
#include <avr/wdt.h> 
//#include <unistd.h>

void delay(long N) {
  long n;
  for (n=0; n<N; n++);
}

int main(void) {
  outp (0xFF,DDRB);/* Data Direction Register: 1 means output; 0 means input*/
  outp (0x00,DDRD);/* set all bits in PORTD to Direction 0 = input */

  //outp(0,PORTB);
  while (1) {
    unsigned char x, y, xi, yi, m;
    xi = inp(PIND);
    x = 0xFF - xi; /* x from x inverse, due to common positive */
    //y = x;  /* your transformation goes here */
    //y = (x<<1) - 1;  /* your transformation, y=y(x), goes here */
    y = 2*x-1;  /* your transformation goes here */
    if (x==0) y=0;

    y=0;
    outp (0xFF-y,PORTB);
    delay(100000);
    y=1;
    for (m=0; m<8; m++) {
      yi = 0xFF - y;
      outp (yi,PORTB);
      delay(100000);
      y=y<<1;
    }
  }
}

